﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

/*
 * @brief 사용자가 동영상 기능(로드/재생)호출 시, 이벤트 처리를 위한 이벤트 핸들러 모음
 */
namespace hive.adkit.daro
{
    public class EventHandlers
    {
        private EventHandlers() { }
        // Common
        public Action onAdLoaded { get; private set; } = null;
        public Action onAdOpening { get; private set; } = null;
        public Action onAdClosed { get; private set; } = null;
        public Action<int, string> onAdFailed { get; private set; } = null;
        public Action onAdClick { get; private set; } = null;
        public Action<RewardItem> onAdReward { get; private set; } = null;
        public Action<AdRevenueData> onAdPaidEvent { get; private set; } = null;

        public class Builder
        {
            private EventHandlers eventHandlers;

            public Builder()
            {
                this.eventHandlers = new EventHandlers();
            }

            public Builder OnAdLoaded(Action args) { eventHandlers.onAdLoaded = args; return this; }
            public Builder OnAdFailed(Action<int, string> args) { eventHandlers.onAdFailed = args; return this; }
            public Builder OnAdOpening(Action args) { eventHandlers.onAdOpening = args; return this; }
            public Builder OnAdReward(Action<RewardItem> args) { eventHandlers.onAdReward = args; return this; }
            public Builder OnAdClosed(Action args) { eventHandlers.onAdClosed = args; return this; }
            public Builder OnAdClick(Action args) { eventHandlers.onAdClick = args; return this; }
            public Builder OnAdPaidEvent(Action<AdRevenueData> args) { eventHandlers.onAdPaidEvent = args; return this; }
            public EventHandlers Build() { return this.eventHandlers; }
        }

    }

}